
#ifndef _ODRM_TLK_ATP_DEFINES_H_
#define _ODRM_TLK_ATP_DEFINES_H_

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */


#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  5-Dec-07
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version ODRM_TLK_ATP_Defines.h#1:incl:1
   *  \author SagitB
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

#include "KMNG_Defs.h"
#include "CRYS_RSA_Types.h" 
#include "tlk_odrm_api.h"


/************************ Global Data **************************/


/************************ Defines ******************************/
/* Defines for Enabling QA main */
/*------------------------------*/
/* Defines for working with/without board */
/*----------------------------------------*/
#define ODRM_TLK_CLEAR_KEY_RING        1 /*tmp*/

/* Defines for Enable log printouts */
/*----------------------------------*/
#define ODRM_TLK_TST_LOG_ENABLE   0
#define ODRM_TLK_LOG_FILE_NAME    "C:\TEMP\LOG\ODRM_TLK_Log.txt"

/* Arrays size Defines */
/*---------------------*/
#ifndef TST_FUNC_STRING_LEN
  #define TST_FUNC_STRING_LEN 100
#endif 
#ifndef TST_NAME_STRING_LEN
  #define TST_NAME_STRING_LEN 150
#endif 


/* Tests defines */
/*--------------*/
#define ODRMTLK_TST_MAX_SIZE_KEY_RING_BUF       6000
#define ODRMTLK_TST_MAX_SIZE_DEV_KEY_RING_BUF   6000
#define ODRMTLK_TST_C2_SIZE                     40
#define ODRMTLK_TST_RI_KEY_SIZE_IN_BITS         1024
#define ODRMTLK_TST_AES_KEY_SIZE                16
#define ODRMTLK_TST_DOUBLE_AES_KEY_SIZE         (ODRMTLK_TST_AES_KEY_SIZE *2)
#define ODRMTLK_TST_KEY_PASS_LENGTH_IN_BYTES    5
#define ODRMTLK_TST_WRAPPED_KEY_LENGTH_IN_BYTES 24
#define ODRMTLK_TST_RSA_1024_KEY_SIZE_IN_BYTES  128
#define Z_SIZE                                  128
#define ODRMTLK_TST_MAX_GENERATION_NUMBER       6
#define ODRMTLK_TST_CURRENT_GENERATION_NUMBER   2
#define ODRMTLK_TST_CBUFF_SIZE                  ODRMTLK_TST_C2_SIZE 
#define ODRMTLK_TST_C_SIZE                      ODRMTLK_TST_RSA_1024_KEY_SIZE_IN_BYTES+ ODRMTLK_TST_DOUBLE_AES_KEY_SIZE + 8


/*temp*/
#define  ODRMTLK_TST_WORKSPACE_SIZE  KMNG_SYM_ENCR_KEY_BUFF_SIZE_IN_BYTES +  KMNG_SYM_ENCR_KEY_BUFF_SIZE_IN_BYTES +  sizeof(CRYS_RSAPrimeData_t)+ TLK_ODRM_RSA_WRAPPED_KEY_SIZE_IN_BYTES

#ifdef __cplusplus
}
#endif
 
#endif
